/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip;

import java.net.InetAddress;
import net.sourceforge.peers.sip.core.useragent.UAS;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldMultiValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.transport.SipMessage;

public class Utils {
    public static final String PEERSHOME_SYSTEM_PROPERTY = "peers.home";
    public static final String DEFAULT_PEERS_HOME = ".";

    public static final SipHeaderFieldValue getTopVia(SipMessage sipMessage) {
        SipHeaderFieldName viaName;
        SipHeaders sipHeaders = sipMessage.getSipHeaders();
        SipHeaderFieldValue via = sipHeaders.get(viaName = new SipHeaderFieldName("Via"));
        if (via instanceof SipHeaderFieldMultiValue) {
            via = ((SipHeaderFieldMultiValue)via).getValues().get(0);
        }
        return via;
    }

    public static final String generateTag() {
        return Utils.randomString(8);
    }

    public static final String generateCallID(InetAddress inetAddress) {
        StringBuffer buf = new StringBuffer();
        buf.append(Utils.randomString(8));
        buf.append('-');
        buf.append(String.valueOf(System.currentTimeMillis()));
        buf.append('@');
        buf.append(inetAddress.getHostName());
        return buf.toString();
    }

    public static final String generateBranchId() {
        StringBuffer buf = new StringBuffer();
        buf.append("z9hG4bK");
        buf.append(Utils.randomString(9));
        return buf.toString();
    }

    public static final String getMessageCallId(SipMessage sipMessage) {
        SipHeaderFieldValue callId = sipMessage.getSipHeaders().get(new SipHeaderFieldName("Call-ID"));
        return callId.getValue();
    }

    public static final String randomString(int length) {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIFKLMNOPRSTUVWXYZ0123456789";
        StringBuffer buf = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            int pos = (int)Math.round(Math.random() * (double)(chars.length() - 1));
            buf.append(chars.charAt(pos));
        }
        return buf.toString();
    }

    public static final void copyHeader(SipMessage src, SipMessage dst, String name) {
        SipHeaderFieldName sipHeaderFieldName = new SipHeaderFieldName(name);
        SipHeaderFieldValue sipHeaderFieldValue = src.getSipHeaders().get(sipHeaderFieldName);
        if (sipHeaderFieldValue != null) {
            dst.getSipHeaders().add(sipHeaderFieldName, sipHeaderFieldValue);
        }
    }

    public static final String getUserPart(String sipUri) {
        int start = sipUri.indexOf(58);
        int end = sipUri.indexOf(64);
        return sipUri.substring(start + 1, end);
    }

    public static final void addCommonHeaders(SipHeaders headers) {
        headers.add(new SipHeaderFieldName("Max-Forwards"), new SipHeaderFieldValue(String.valueOf(70)));
    }

    public static final String generateAllowHeader() {
        StringBuffer buf = new StringBuffer();
        for (String supportedMethod : UAS.SUPPORTED_METHODS) {
            buf.append(supportedMethod);
            buf.append(", ");
        }
        int bufLength = buf.length();
        buf.delete(bufLength - 2, bufLength);
        return buf.toString();
    }
}

